//Declaring the pixijs starter
console.log("JavaScript is running!");
const app = new PIXI.Application();
await app.init({width: 640, height: 480, backboxColor: 0x333333, hello: true, antialias: true});
const pixiContainer = document.querySelector("#pixiContainer");
pixiContainer.appendChild(app.canvas);

//Making a container
console.log("Creating containter (contOne)");
const contOne = new PIXI.Container();
app.stage.addChild(contOne);

//Making an object, that being a box
console.log("Drawing box");
const box = new PIXI.Graphics();
box.rect(0, 0, 640, 100);
box.fill({color: 0x220878});
box.stroke({color: 0x204852, width: 3});
box.zIndex = 1;
contOne.addChild(box);

//styling the text
console.log("Drawing top text");
const myTextStyle = new PIXI.TextStyle({
     fontFamily: 'Gill Sans',
     fontSize: 30,
     fill: '#ffffff',
});

//Quetion number text object
const myText = new PIXI.Text({text: "Placeholdr text", style: myTextStyle});
myText.x = 240;
myText.y = 15;
app.stage.addChild(myText);

//Question text object
const myText2 = new PIXI.Text({text: "Placeholdr text", style: myTextStyle});
myText2.x = 20;
myText2.y = 45;
app.stage.addChild(myText2);

//Button 1 object
const navSpot = new PIXI.Graphics();
navSpot.rect(180, 150, 280, 80);
navSpot.fill({color: 0xFF0000});
navSpot.scale.set(0);
app.stage.addChild(navSpot);

//Button 1 text object
const answer1T = new PIXI.Text({text: "PText", style: myTextStyle});
answer1T.x = 200;
answer1T.y = 170;
app.stage.addChild(answer1T);

//Button 2 object
const navSpot2 = new PIXI.Graphics();
navSpot2.rect(180, 250, 280, 80);
navSpot2.fill({color: 0xFF0000});
navSpot2.scale.set(0);
app.stage.addChild(navSpot2);

//Button 2 text object
const answer2T = new PIXI.Text({text: "Ptext", style: myTextStyle});
answer2T.x = 200;
answer2T.y = 270;
app.stage.addChild(answer2T);

//Button 3 object
const navSpot3 = new PIXI.Graphics();
navSpot3.rect(180, 350, 280, 80);
navSpot3.fill({color: 0xFF0000});
navSpot3.scale.set(0);
app.stage.addChild(navSpot3);

//Button 3 text object
const answer3T = new PIXI.Text({text: "Ptext", style: myTextStyle});
answer3T.x = 200;
answer3T.y = 370;
app.stage.addChild(answer3T);

//Score text object
const score = new PIXI.Text({text: "Score: 0", style: myTextStyle});
score.x = 10;
score.y = 440;
app.stage.addChild(score);

//variables used later in the code
var scoreNum = 0;
var number1 = 0;

//The end screen function removes all the buttons and adds a text object telling you you won if all questions have been answered. The original intention was for it to only do this if your score is exactly 5 but as stated below after an hour and a half of trying i could not get it to properly increase the number, only decrease.
function endScreen() {
     if (number1 == 6) {
          navSpot.alpha = 0;
          navSpot2.aplha = 0;
          navSpot3.alpha = 0;
          answer1T.alpha = 0;
          answer2T.alpha = 0;
          answer3T.alpha = 0;

          const winner1 = new PIXI.Text({text: "YOU WINNN!!!", style: myTextStyle});
          winner1.x = 200;
          winner1.y = 270;
          app.stage.addChild(winner1);
     }
}

//function that changes the questions and answers. After all have been cycled through it calls the end screen function
function questionChange(){
     console.log(number1);
     if (number1 == 0) {
          myText.text = "QUESTION 1"
          myText2.text = "What year did Oppenheimer release?"
          answer1T.text = "2020"
          answer2T.text = "2023"
          answer3T.text = "2024"
     }
     if (number1 == 1) {
          myText.text = "QUESTION 2"
          myText2.text = "What is the highest grossing movie of all time?"
          answer1T.text = "Avatar"
          answer2T.text = "Titanic"
          answer3T.text = "Avengers: Endgame"
     }
     if (number1 == 2) {
          myText.text = "QUESTION 3"
          myText2.text = "What is the longest film ever made?"
          answer1T.text = "La flor"
          answer2T.text = "Out 1 (Noli me tangere)"
          answer3T.text = "Resan (The Journery"
     }
     if (number1 == 3) {
          myText.text = "QUESTION 4"
          myText2.text = "What is the most expensive movie of all time?"
          answer1T.text = "SW: The Force Awakens"
          answer2T.text = "JW: Fallen Kingdom"
          answer3T.text = "SW: The Rise of Skywalker"
     }
     if (number1 == 4) {
          myText.text = "QUESTION 5"
          myText2.text = "What was the budget for James Cameron's 'Titanic'"
          answer1T.text = "$186 Million"
          answer2T.text = "$200 Million"
          answer3T.text = "$150 Million"
     }
     number1 += 1;
     endScreen();
}
questionChange();

//Nav Pin animations
gsap.to(navSpot, {delay: 0, duration: .1, pixi: {scale: 1}});
gsap.to(navSpot2, {delay: 0, duration: .1, pixi: {scale: 1}});
gsap.to(navSpot3, {delay: 0, duration: .1, pixi: {scale: 1}});

//make buttons interactive
navSpot.eventMode = "static";
navSpot.cursor = "pointer";
navSpot2.eventMode = "static";
navSpot2.cursor = "pointer";
navSpot3.eventMode = "static";
navSpot3.cursor = "pointer";

//add event listeners to interactive object for each of the respective buttons
navSpot.addEventListener('pointerover', onNavSpotOver);
navSpot.addEventListener('pointerout', onNavSpotOut);
navSpot.addEventListener('pointerdown', onNavSpotDown1);
navSpot2.addEventListener('pointerover', onNavSpotOver2);
navSpot2.addEventListener('pointerout', onNavSpotOut2);
navSpot2.addEventListener('pointerdown', onNavSpotDown2);
navSpot3.addEventListener('pointerover', onNavSpotOver3);
navSpot3.addEventListener('pointerout', onNavSpotOut3);
navSpot3.addEventListener('pointerdown', onNavSpotDown3);

//hover functions for each of the respective buttons
function onNavSpotOver(){
     gsap.to(navSpot, {duration: .25, pixi: {scale: 1.025}});   
}
function onNavSpotOut(){
     gsap.to(navSpot, {duration: .05, pixi: {scale: 1}});
}
function onNavSpotOver2(){
     gsap.to(navSpot2, {duration: .25, pixi: {scale: 1.025}});   
}
function onNavSpotOut2(){
     gsap.to(navSpot2, {duration: .05, pixi: {scale: 1}});
}
function onNavSpotOver3(){
     gsap.to(navSpot3, {duration: .25, pixi: {scale: 1.025}});   
}
function onNavSpotOut3(){
     gsap.to(navSpot3, {duration: .05, pixi: {scale: 1}});
}

// I was having an issue with increasing the score where no matter where I put it or what I changed it just refused to actually increase the score. Decreasing works correctly. I wrote increasing the score as if it was working correctly because by all means it SHOULD be working.

//FIRST Trivia Button Function
function onNavSpotDown1(){
     //change the questions
     if (number1 == 1) {
          //When the question is wrong, take away 1 point
          scoreNum -= 1;
          score.text = "Score: " + scoreNum;
     }
     if (number1 == 2) {
          //When the question is right, add 1 point and call the question changer function
          questionChange();
          scoreNum += 1;
          score.text = "Score: " + scoreNum;
     }
     if (number1 == 3) {
          scoreNum -= 1;
          score.text = "Score: " + scoreNum;
     }
     if (number1 == 4) {
          questionChange();
     }
     if (number1 == 5) {
          scoreNum -= 1;
          score.text = "Score: " + scoreNum;
     }
}

//SECOND Trivia Button Function
function onNavSpotDown2(){
     //change the questions
     if (number1 == 1) {
          questionChange();
          scoreNum += 1;
          score.text = "Score: " + scoreNum;
          
     }
     if (number1 == 2) {
          scoreNum -= 1;
          score.text = "Score: " + scoreNum;
     }
     if (number1 == 3) {
          scoreNum -= 1;
          score.text = "Score: " + scoreNum;
     }
     if (number1 == 4) {
          scoreNum -= 1;
          score.text = "Score: " + scoreNum;
     }
     if (number1 == 5) {
          questionChange();
          scoreNum += 1;
          score.text = "Score: " + scoreNum;
          navSpot2.alpha = 0; //this line fixes a bug where the final button would not disapear
          
     }
}

//THIRD Trivia Button Function
function onNavSpotDown3(){
     //change the questions
     if (number1 == 1) {
          scoreNum -= 1;
          score.text = "Score: " + scoreNum;
     }
     if (number1 == 2) {
          scoreNum -= 1;
          score.text = "Score: " + scoreNum;
     }
     if (number1 == 3) {
          questionChange();
          scoreNum += 1;
          score.text = "Score: " + scoreNum;
     }
     if (number1 == 4) {
          scoreNum -= 1;
          score.text = "Score: " + scoreNum;
     }
     if (number1 == 5) {
          scoreNum -= 1;
          score.text = "Score: " + scoreNum;
     }
}